# Open Content Base lab instructions
This is the Open Content lab documentation. This document holds instructions for the excercises. 

### Set environment variable                                                      
You need to prepare your terminal environment with an `OpenContentIp` variable and the location of your `pemfile` for accessing the AWS EC2 host. Running the following command in your terminal window in the same directory as this file will set `OpenContentIp` which is used by the sample scripts:
 
    source settings
    
In the root directory of this repository you will find a small convenient `manage` script. Too get this script in your `${PATH}` environment execute the following command in your terminal shell.

     export PATH=$(PWD):${PATH}
    
You can verify your environment by typing `echo ${OpenContentIp}` then the ip adress to your Open Content will be printed in your terminal. This indicates that you have set the environment variable named `OpenContentIp` which will be used by the sample script in following labs.


## Swagger API
Open Content API is documented in Swagger. Below is the link to the Swagger Open Content REST API on your Open Content host.

Using the 'manage' script:

    manage apidocs
 
For Chrome use this on OSX:
     
    /usr/bin/open -a "/Applications/Google Chrome.app" http://${OpenContentIp}:8080/opencontent/apidocs/

Use default browser use this: 
     
    open  http://${OpenContentIp}:8080/opencontent/apidocs/
     
Swagger is a powerful representation of RESTful API's. All API calls will be executed towards the Open Content holding the API documentation. The UI will provide request/response details, also curl and request url examples will be given for the different Open Content Rest URLs.        

## Excercises
Each chapter in this document is supported by a directory 'x-yyyyyyyy' (except for exercise 5 which is in this document only)

***Important*** Make sure that you have the `OpenContentHostIp` environment variable set!
 
## 0-config 
Running this script will configure Open Content. 

    ./configure.sh

## 1-upload-article

Upload curl command is described here :
https://wiki.infomaker.se/display/OCS/Curl

Will upload an 'Article' to Open Content. Configuration for this is done in previous exercise.

* Edit the file `my-article.xml`
* Execute the script `./upload-article.sh`

The script if successful will print an UUID and 201 (response code)

Use XLibris to verify upload! ( In terminal : 'manage xlibris')  

Try to upload the same object again, what happens ?

### API examples
View information about the content object:
 
Files

    curl -u admin:admin -s http://${OpenContentIp}:8080/opencontent/objects/<ARTICLE-UUID>/files | python -m json.tool
    
Properties    
   
    curl -u admin:admin -s http://${OpenContentIp}:8080/opencontent/objects/<ARTICLE-UUID>/properties | python -m json.tool

Get the stored content
    
    curl -u admin:admin -s http://${OpenContentIp}:8080/opencontent/objects/<ARTICLE-UUID> --output <ARTICLE-UUID>.xml 

## 2-upload-image
An Image will be uploaded to Open Content. Configuration for this is done in advance.
The script if successful will print a UUID and 201 (response code)

Use XLibris to verify upload!

Try to upload the same object again, what happens?

### API examples

Content (image file)

    /usr/bin/open -a "/Applications/Google Chrome.app" http://${OpenContentIp}:8080/opencontent/objects/<UUID>  

Preview/Thumbnail
 
    /usr/bin/open -a "/Applications/Google Chrome.app" http://${OpenContentIp}:8080/opencontent/objects/<UUID>/files/preview.jpg
    /usr/bin/open -a "/Applications/Google Chrome.app" http://${OpenContentIp}:8080/opencontent/objects/<UUID>/files/thumb.jpg

## 3-update
The 'Article' property 'ImageUuid' in lab 1 will be updated. This will set a relation between the uploaded Article and the Image.
 
    ./update.sh <ARTICLE-UUID> ImageUuids <IMAGE-UUID>

Verify in XLibris that the Article knows about The Image and vice versa.

Use curl command to verify relation

    curl -u admin:admin -s ${OpenContentIp}:8080/opencontent/objects/<ARTICLE-UUID>/relations | python -m json.tool
 
    curl -u admin:admin -s ${OpenContentIp}:8080/opencontent/objects/<IMAGE-UUID>/relations | python -m json.tool

## 3.1-Create Contenttype relation extractor

Open Open Content Admin. In "Content types" menu for content type Article:

  Add a property for Article called Images of type "Image". This is the property that will hold related Images.

In Extractors menu for content type Article, add relation (contenttype). Select Images. The relation is ImageUuids properties = uuid for an Image.

Activate the configuration.

Examine result in the browser:

    http://<host>:8080/opencontent/objects/[article-uuid]/properties?name=uuid&name=Images.uuid
    
or with curl:
    
    curl -s -u admin:admin "${OpenContentIp}:8080/opencontent/objects/[article-uuid]/properties?name=uuid&name=Images.uuid" | python -m json.tool

Configure the reverse for Image Articles and then try this in the browser:

    http://<host>:8080/opencontent/objects/[image-uuid]/properties?name=uuid&name=Articles.uuid
    
or with curl:

    curl -s -u admin:admin "${OpenContentIp}:8080/opencontent/objects/[image-uuid]/properties?name=uuid&name=Articles.uuid" | python -m json.tool

Properties can be nested, try in the browser:

    http://<host>:8080/opencontent/objects/[image-uuid]/properties?name=uuid&name=Articles.uuid&name=Articles.Images.uuid
    
or with curl:

    curl -s -u admin:admin "${OpenContentIp}:8080/opencontent/objects/[image-uuid]/properties?name=uuid&name=Articles.uuid&name=Articles.Images.uuid" | python -m json.tool

## 4-delete
Show how to delete a content object using delete 

    ./delete.sh <UUID>
     
Verify deletion in XLibris

Delete the rest of the content:

    ./delete-all.sh


## 5-Search
Show how to use the Search API

Get everything
     
    curl -s -u admin:admin ${OpenContentIp}:8080/opencontent/search?q=*:* | python -m json.tool
    
Search by uuid property

    curl -s -u admin:admin ${OpenContentIp}:8080/opencontent/search?q=uuid:<UUID> | python -m json.tool
    
Search all fields
    
    curl -s -u admin:admin ${OpenContentIp}:8080/opencontent/search?q="learn" | python -m json.tool
    
Set properties in response
    
    curl -s -u admin:admin "${OpenContentIp}:8080/opencontent/search?q=*:*&property=contenttype" | python -m json.tool
    
Limit answers, will get the first
    
    curl -s -u admin:admin "${OpenContentIp}:8080/opencontent/search?q=*:*&limit=1&property=contenttype" | python -m json.tool
    
Set start, will get the second 
    
    curl -s -u admin:admin "${OpenContentIp}:8080/opencontent/search?q=*:*&limit=1&start=1&property=contenttype" | python -m json.tool

More about Lucene syntax : http://lucene.apache.org/core/4_1_0/queryparser/org/apache/lucene/queryparser/classic/package-summary.html#package_description


## 6-Xpath
Extraction of properties values are done from xml files using XPaths. More about XPath can be found here:
 
    http://www.w3schools.com/xml/xsl_functions.asp

## Challange yourself

Add xpaths for "caption", "description", "photodate" and "product" for content type Image 


## 7-Merge configuration
It is possible to save the configuration of an Open Content to a file which can be used for replacement or merge of configuration. 
The replace will apply the settings found in the uploaded settings file to Open Content. Which means that the Open Content configuration will be identical to the new configuration file.
 
The merge configuration will append the settings from another configuration file to the existing configuration  

You can test to merge configuration by usng the 'demo-oc-exported-active.yaml' file in the 07-config-merge directory. In OC Admin UI select Configuration/Import/Export. Under Import select merge configuration and use the 'demo-oc-exported-active.yaml' file.

## 8-Replication

It is possible to copy content from one Open Content to another. For this we use the Open Content Replicator.
 
## Installed replicator
To go to the replicator use 'manage'
    
    manage replicator

Try to replicate content from your different Open Content installations. 


### Docker
Our registry is only accessible from our own network, so this can not be done when outside of our office or not connected to our VPN.

The replicator is a dockerized application. To be able to run the dockerized Open Content Replicator docker has to be installed on your system. Follow instructions here to install Docker on your system https://www.docker.com/docker-mac

When Docker is installed the script in directory 8-replication will help you to perform a replication. Use the start-replication.sh script.

The Open Content Replicator UI can be accessed using http://localhost:8180/replication.

Query for Article
uuid:fb69eef0-fb53-461b-87d6-5d68e499d3a3

Query for images
uuid:2cb28d97-d02f-58ca-af75-fd57734eb666 OR uuid:31db91be-62d9-5d23-bf95-150876311955 OR uuid:8857b298-ffd1-5689-88ee-3a02329b6752 OR uuid:706f37db-aa3c-58ef-9cbc-158374cba2e9 OR uuid:ce1b7e76-0026-566e-9a28-1fcc95563642

Test Article/Images contenttype property

## 9-Versioning

Open Content supports versioning of files. Set versioning to 0, indicates infinite number of versions. Update your article. Now it is possible to get properties for earlier versions of the object. 
