#!/usr/bin/env bash

read -p "Url [http://127.0.0.1:8080] : " OC_URL
read -p "Username  [admin]: " USER
read -p "Password  [admin]: " PWD

OC_URL=${OC_URL:-http://127.0.0.1:8080}
USER=${USER:-admin}
PWD=${PWD:-admin}

PersistedEventFile=lastevent
sleep=5


function setPropertyValue() {
    local  __resultvar=${1}
    local  __resultvar_length="${1}_length"
    local  __resultvar_multivalue="${1}_multivalue"

    _Property=${1}
    _json=${2}

    length=$(echo ${_json} | PropertyName="${_Property}" jq -r '.[] | select(.name == env.PropertyName) | .values | length')
    if [ "${length}" == "" ];then
        length=0
    fi
    value=$(echo ${_json} | PropertyName="${_Property}" jq -r '.[] | select(.name == env.PropertyName) | .values[]')
    multivalue=$(echo ${_json} | PropertyName="${_Property}" jq '.[] | select(.name == env.PropertyName) | .multiValued')
    eval $__resultvar="'$value'"
    eval $__resultvar_length="'$length'"
    eval $__resultvar_multivalue="'$multivalue'"
}


function handleArticleItem() {
    _uuid=${1}
    _version=${2}

    # if versioning is used the specific version can be fetched
    # _cmd="curl -s -u ${USER}:${PWD} \"${OC_URL}/opencontent/objects/${_uuid}/properties?version=${_version}&properties=NewsPrio\""

    # build the command to get wanted properties
    _cmd="curl -s -u ${USER}:${PWD} \"${OC_URL}/opencontent/objects/${_uuid}/properties?&properties=NewsPrio,uuid,version,mimetype,Section,Headline,Leadin,ArticleBodyRaw\""

    # get the properties
    _itemResponse=$(eval "${_cmd}")
    _properties=$(echo ${_itemResponse} | jq -r '.properties')


    # get the properties values
    setPropertyValue "uuid" "${_properties}"
    setPropertyValue "version" "${_properties}"
    setPropertyValue "mimetype" "${_properties}"
    setPropertyValue "Section" "${_properties}"
    setPropertyValue "NewsPrio" "${_properties}"

    # handle if value is missing
    if (( ${NewsPrio_length} == 0));then
        NewsPrio="missing"
    fi

    setPropertyValue "Headline" "${_properties}"
    setPropertyValue "Leadin" "${_properties}"


    # process leadin <p> and </p>
    Leadin="${Leadin//<p>/}"
    Leadin="${Leadin//<\/p>/}"

    setPropertyValue "ArticleBodyRaw" "${_properties}"

    # show the item details
    echo "Section: [${Section}] NewsPrio: [${NewsPrio}] Mimetype: [${mimetype}]"
    echo "${Headline}"
    if (( ${Leadin_length} > 0 ));then
        echo -e "${Leadin}"
    else
        echo "!! Leadin missing !!"
    fi
    # Only print article body if not empty
    if ((${ArticleBodyRaw_length} > 0 ));then
        # echo "${ArticleBodyRaw}"
        echo "............................."
        xmllint --nowarning --format "$query" - <<<"${ArticleBodyRaw}"
        echo "............................."
    else
        echo "!! Missing ArticleBodyRaw !!"
    fi
}

function processEvent() {
    _event=${1}

    # get the current id of the event
    EventId=$(echo ${_event} | jq -r .id)
    EventType=$(echo ${_event} | jq -r .eventType)
    created=$(echo ${_event} | jq -r .created)
    uuid=$(echo ${_event} | jq -r .content.uuid)
    version=$(echo ${_event} | jq -r .content.version)
    contentType=$(echo ${_event} | jq -r .content.contentType)

    echo "${EventId}.${EventType}.${created}.${contentType}.${uuid}.${version}"
     if [ "${contentType}" == "Article" ];then
         echo "======================================[ Article info ]==========================================="
         handleArticleItem ${uuid} ${version}
         echo "------------------------------------------------------------------------------------------------------"
         # persist the handled event
     fi
    echo ${EventId} > ${PersistedEventFile}
}

function getEventLog() {
    _event=${1}
    # get the response for the latest event
    response=$(curl -s -u ${USER}:${PWD} ${OC_URL}/opencontent/eventlog?event=${_event})

    # handle when events == 0 event skip the sleep delay
    numberOfEvents=$(echo ${response} | jq -r '.events | length')
    if (( ${numberOfEvents} == 0 )); then
        # no more go for sleep
        return
    fi

    # loop throw the event in response
    for row in $(echo "${response}" | jq -r '.events[] | @base64'); do
        decoded=$(echo ${row} | base64 --decode)
        processEvent "${decoded}"
    done

    # see if more fetch more
    getEventLog ${EventId}
}

function setFirstEventId() {
    _response=$(curl -s -u ${USER}:${PWD} ${OC_URL}/opencontent/eventlog?event=-1)
    length=$(echo ${_response} | jq '.events | length')
    index=$(( ${length} - 1 ))
    echo ${index}
    EventId=$( echo ${_response} | index=${index} jq .events[${index}].id)
}

# check if event is persisted
if [ -f ${PersistedEventFile} ];then
    EventId=$(cat lastevent)
    echo "found ${PersistedEventFile} starting at event ${EventId}"
else
    setFirstEventId
    echo "'${PersistedEventFile}' file is missing last event in Open Content is:  ${EventId}"
fi

# ask for events
while [ 1 ]
do
    getEventLog ${EventId}
    sleep ${sleep}
done
