#!/usr/bin/env bash

# Deletes the selected uuid
uuid=${1}

if [ -z ${uuid} ];then
    echo "ERROR: missing argument; Usage: ${0} <uuid>"
    exit 1
fi


# Open Content server
source ../settings
oc_server=${OpenContentIp}


# Open Content user/pwd
user=admin
pwd=admin


curlCmd="curl --write-out %{http_code} -u ${user}:${pwd} ${output} -X DELETE"
curlCmd="${curlCmd} http://${oc_server}:8080/opencontent/objects/${uuid}"

echo "Curl command for delete: ${uuid}"
echo ${curlCmd}

${curlCmd}
echo ""



