#!/bin/bash

# This script will delete all content on Open Content

# Open Content server
source ../settings
oc_server=${OpenContentIp}

host=${oc_server}
username=admin
password=admin

limit=10000

curl -s -u ${username}:${password} ${host}:8080/opencontent/search?property=uuid\&facet=false\&limit=${limit} | grep -Eo uuid....[0-9,a-f,A-F]{8}-[0-9,a-f,A-F]{4}-[0-9,a-f,A-F]{4}-[0-9,a-f,A-F]{4}-[0-9,a-f,A-F]{12}| grep -Eo [0-9,a-f,A-F]{8}-[0-9,a-f,A-F]{4}-[0-9,a-f,A-F]{4}-[0-9,a-f,A-F]{4}-[0-9,a-f,A-F]{12} > /tmp/uuids-to-delete.txt

curl_command="curl -u ${username}:${password} -s -w %{http_code} -X DELETE http://${host}:8080/opencontent/objects/"

while read uuid; do
    # echo "uuid ${uuid}"
    # CURLCOMMAND="curl -s -w %{http_code} ${SERVER_IP}:8080/opencontent/health -o /dev/null"
    RESPONSE=409
    while [ ${RESPONSE} == "409" ];do
        # echo ${curl_command}${uuid}
        RESPONSE=$(${curl_command}${uuid})
        if [ ${RESPONSE} == "200" ];then
            echo "${RESPONSE} ${uuid} deleted from ${host}"
        elif [ ${RESPONSE} == "409" ];then
            echo "${RESPONSE}  ${uuid} is currently being reindexed, will try again in 2s"
            sleep 2
        else
            echo "${RESPONSE} ${uuid} could NOT be deleted from ${host}"
        fi
    done
done < /tmp/uuids-to-delete.txt
