#!/usr/bin/env bash

SERVER_DIR=~/oc-lab-box
# Open Content server
source ../settings
oc_server=${OpenContentIp}

uuid=${1}
PropertyName=${2}
NewValue=${3}

if [ -z ${1} ] || [ -z {2} ] || [ -z {3} ];then
    echo ""
    echo "ERROR: Empty argument; syntax ${0} <uuid> <propertyname> <newvalue>"
    echo ""
    exit 1
fi

# Open Content user/pwd
user=admin
pwd=admin


curlCmd="curl --write-out  \n%{http_code}\n -u ${user}:${pwd} ${output} -X PUT"
curlCmd="${curlCmd} http://${oc_server}:8080/opencontent/objects/${uuid}/properties?${PropertyName}.UPDATEINDEX=1&${PropertyName}.UPDATE=${NewValue}"

echo "Curl command for put:"
echo ${curlCmd}

${curlCmd}
