#!/usr/bin/env bash

ImageFile="streckgubbe.jpg"
MimeType=image/jpg
ImageMetaFile=image-meta.xml
Thumb="thumb.jpg"
Preview="preview.jpg"

# Open Content server
source ../settings
oc_server=${OpenContentIp}

# Open Content user/pwd
user=admin
pwd=admin

# Source for the uploaded content
source="lab-$(whoami)"

# uuid set from client
uuid=$(uuidgen | tr '[:upper:]' '[:lower:]')

mimetype="application/vnd.infomaker.se-lab.image"
# output="--output /dev/null"

curlCmd="curl --write-out \n%{http_code}\n -u ${user}:${pwd} -s ${output} -X POST -F id=${uuid}"
curlCmd="${curlCmd} -F source=${source}"
curlCmd="${curlCmd} -F file=${ImageFile} -F file-mimetype=${MimeType} -F ${ImageFile}=@${ImageFile}"
curlCmd="${curlCmd} -F metadata=${ImageMetaFile} -F metadata-mimetype=${mimetype} -F ${ImageMetaFile}=@${ImageMetaFile}"
curlCmd="${curlCmd} -F preview=preview.jpg -F preview-mimetype=${MimeType} -F preview.jpg=@${Preview}"
curlCmd="${curlCmd} -F thumb=thumb.jpg -F thumb-mimetype=${MimeType} -F thumb.jpg=@${Thumb}"
curlCmd="${curlCmd} http://${oc_server}:8080/opencontent/objectupload"

echo "Upload simple-article with curl"
echo ${curlCmd}
echo "==================================================================="
${curlCmd}
echo ""



