#!/usr/bin/env bash

ArticleFile="my-article.xml"

# Open Content server
source ../settings
oc_server=${OpenContentIp}

# Open Content user/pwd
user=admin
pwd=admin

# Source for the uploaded content
source="lab-$(whoami)"

if [ ! -z ${1} ];then
	uuid=${1}
else
	# uuid set from client
	uuid=$(uuidgen | tr '[:upper:]' '[:lower:]')
fi

mimetype="application/vnd.infomaker.se-lab.article"
# output="--output /dev/null"


curlCmd="curl --write-out \n%{http_code}\n -u ${user}:${pwd} -s ${output} -X POST -F id=${uuid}"
if [ ! -z ${2} ];then
	curlCmd="${curlCmd} -F action=${2}"
fi
curlCmd="${curlCmd} -F source=${source}"
curlCmd="${curlCmd} -F file=${ArticleFile} -F file-mimetype=${mimetype} -F ${ArticleFile}=@${ArticleFile}"
curlCmd="${curlCmd} -F metadata=${ArticleFile} -F metadata-mimetype=${mimetype} -F ${ArticleFile}=@${ArticleFile}"
curlCmd="${curlCmd} http://${oc_server}:8080/opencontent/objectupload"

echo "Upload simple-article with curl"
echo ${curlCmd}
echo "==================================================================="
${curlCmd}
echo ""



