#!/usr/bin/env bash

source ../settings
OpenContentHost=${OpenContentIp}

echo ""
echo "INFO: Configure ${OpenContentHost}"
echo ""
# Add disk for config
# curl -u admin:admin -X POST --header "Content-Type: application/x-www-form-urlencoded" --header "Accept: application/json" -d "name=Infomaker&path=%2Fdata%2Fopencontent&type=FILE" "http://${OpenContentHost}:8080/opencontent/admin/storage"
# Commented since the S3 bucket to use is configured at installation

# Upload config for lab
curl -u admin:admin -X POST --data-binary @lab-config.yaml http://${OpenContentHost}:8080/opencontent/admin/configuration/replace-yaml


# Activate config
curl -u admin:admin -X POST --header "Content-Type: application/x-www-form-urlencoded" --header "Accept: application/json" -d "reason=Creation%20of%20environment&name=OC%20Team" "http://${OpenContentHost}:8080/opencontent/admin/configuration/activate"

# Start incremental indexing
# curl -X POST http://${OpenContentHost}:9000/incremental/start


echo ""
echo "INFO: Configuration of ${OpenContentHost} done!"
echo ""